function plotHandle = beamPlotPol(paHandle, theta, gain)
%% beamPlotPol - Polar plot for beam pattern
% Basic polar plot with several preconfigured properties.
% Returns plot handle for further extendability.

% Inputs : incident angle [rad], gain [dB]
% Outputs: plot handle
%%
pa = paHandle;
% Plot data
pp = polarplot(theta, gain + abs(min(gain))); % offset by greatest negative value

% Properties
title('Polar');
%pa.ThetaLim = [0 180];
pa.ThetaAxisUnits = 'degrees';
%pa.RTickLabel = {'-50','-40','-30','-20','-10','0'};

pa.ThetaDir = 'clockwise';
pa.ThetaZeroLocation = 'top';
% Return
plotHandle = pp;
end